module PayoutEntities
  class Base < Service::Base
    self.service_endpoint = Settings.moneypenny.endpoint

    def self.ldap_headers(options)
      ldap_login = options[:ldap_login] || ""
      headers = {"Twitch-LDAP-Login" => ldap_login}

      headers
    end

    def self.make_params(options)
      channel_input = options[:channel_input]

      keys_regex = {
        channel_id: /^\d+$/,
        login: /^[a-zA-Z0-9][a-zA-Z0-9_]+$/,
      }

      params = keys_regex.inject({}) do |_, (key, regex)|
        _[key] = channel_input if channel_input =~ regex
        _
      end

      params.merge! options

      params
    end
  end
end
