module PayoutEntities
  class Workflow < PayoutEntities::Base
    attributes :workflow_id

    self.primary_attribute = :workflow_id

    CONTRACT_BLANK_DATE = "0001-01-01T00:00:00Z"

    CATEGORY_DEVELOPER = "Developer"

    def self.find(workflow_id, options)
      response = get "/payout/workflow/#{workflow_id}/events", headers: ldap_headers(options)

      return {} unless response.success?
      return response.body["workflow_events"]
    end

    def self.restart(channel_id, options)
      response = delete "/payout/#{channel_id}/workflow", headers: ldap_headers(options)
      response.success?
    end

    def self.invitation_category(invitation_id, options)
      response = get "/payout/invitation/#{invitation_id}", headers: ldap_headers(options)

      return {} unless response.success?

      terms = PayoutEntities::Invitation.partner_terms_from_tags(response.body["tags"])
      category = response.body["category"].try(:humanize)

      return terms.present? ? "#{terms} #{category}" : category
    end

    def self.user_attributes_by_channel_id(channel_id, options)
      response = get "/payout/#{channel_id}/user_attributes", headers: ldap_headers(options)

      return {} unless response.success?
      return response.body
    end

    def self.user_attributes(workflow_id, options)
      response = get "/payout/workflow/#{workflow_id}/user_attributes", headers: ldap_headers(options)

      return {} unless response.success?
      return response.body
    end

    def self.migrate_legacy_workflow(workflow_id, options)
      response = delete "/payout/workflow/#{workflow_id}", headers: ldap_headers(options)

      return response.success?
    end
  end
end
