module Rbac
  class Membership < Rbac::Base
    include Code::Justin::Tv::Devrel::Rbac

    ROLE_OWNER = "Owner"
    ROLE_BILLING_MANAGER = "Billing_Manager"
    ROLE_ADMIN = "Administrator"
    ROLE_SHADOW_ACCOUNT = "Shadow_Account"

    def self.find_memberships(user_id)
      list_memberships_req = ListCompanyMembershipsRequest.new(twitch_id: user_id)
      resp = Membership.client.list_company_memberships(list_memberships_req)

      if resp.error
        [{}, resp.error]
      else
        [Hash[resp.data.memberships.map { |membership| [membership.company.id, membership] }], nil]
      end
    end
  end
end
