module RevenueReporting
  class FraudReport < RevenueReporting::Base

    attributes :success_message, :error_message

    def invoke_lambda(report_id, tab_type)
      if tab_type.eql?("fraud_report")
        # Fraud report Tab
        function_name = Settings.revenuereporting.fraud.lambda_arn.fraud_report_job
        session_name  = '6e2aaae8-1ad6-11eb-adc1-0242ac120002'
        success_message = "<a href='https://docs.google.com/spreadsheets/d/" + report_id + "'>Fraud Report</a> processed."
      else
        # Block Payouts Tab
        function_name = Settings.revenuereporting.fraud.lambda_arn.block_payouts
        session_name  = '6e2abce8-1ad6-11eb-adc1-0242ac120992'
        success_message = "Payout blocking processed on report."
      end
      # invoke a lambda
      aws_credentials = Aws::AssumeRoleCredentials.new(
        client: Aws::STS::Client.new(region: 'us-west-2'),
        role_arn: Settings.revenuereporting.fraud.role_arn,
        role_session_name: session_name
      )
      client = Aws::Lambda::Client.new(region: 'us-west-2',
                                       credentials: aws_credentials)
      payload = {
          report_id: report_id
      }.to_json
      resp = client.invoke({
          function_name: function_name,
          invocation_type: 'RequestResponse',
          log_type: 'None',
          payload: payload
      })
      # provide feedback on status of lambda job
      resp_payload = JSON.parse(resp.payload.string)
      if !resp_payload["errorMessage"].nil?
        self.error_message   = resp_payload["errorMessage"]
      else
        self.success_message = success_message
      end
      resp_payload["errorMessage"].nil?
    end

  end
end
