module RevenueReporting
  class PayoutDetail < RevenueReporting::Base

    attributes :currency, :month, :year, :current_prime_payout, :deferred_prime_payout

    def self.all_prime(channel_id)
      return [] if channel_id.blank?
      response = get "/internal/dashboard/prime_payout_details?channel_id=#{channel_id}"

      payout_details = []
      if response.success?
        payout_details = response.body['prime_payout_history'].map do |run|
          from_attributes(run)
        end
      else
        return nil
      end

      return payout_details
    end
  end
end
