module RevenueReporting
  class Report < RevenueReporting::Base

    self.primary_attribute = :id

    attributes :id, :report_type, :start_date, :end_date, :state, :created_at, :url

    def self.all(options = {})
      response = get "/finance/runs"

      reports = []
      if response.success?
        reports = response.body.collect do |run|
          from_attributes(run)
        end
      end

      paginate reports
    end

    def save
      self.end_date = self.start_date

      response = post "/finance/runs", body: as_json
      unless response.success?
        if response.body["message"].present?
          self.errors = response.body["message"]
        else
          self.errors = "Report could not be started. Please try again in a minute."
        end
      end

      response.success?
    end

  end
end
