module Ripley
  class ValidatedNonPartner < Ripley::Base
    def self.find(user_id)
      response = twirp_client.get_validated_non_partner_status(channel_id: user_id)
      raise response.error.msg if response.error
      response.data.is_validated_non_partner
    end

    def self.delete(user_id)
      twirp_client.delete_validated_non_partner_status(channel_id: user_id)
    end

    def self.add(user_id)
      twirp_client.add_validated_non_partner_status(channel_id: user_id)
    end
  end
end
