# frozen_string_literal: true

module Staff
  class Member < Staff::Base
    attributes :id, :cn, :email, :groups

    self.service_endpoint = Settings.guardian.endpoint
    self.primary_attribute = :id

    def self.activity_logs
      @activity_logs ||= Twitch::ActivityLog::Client.new(
        environment: Settings.activity_log.environment
      )
      @activity_logs
    end

    def self.find(id)
      response = get "/ldap/users/#{id}"

      if response.success?
        from_attributes(response.body['data']['attributes'].update(id: id))
      else
        member = from_errors(response.body['errors'].map { |x| x['detail'] })
        member.id = id
        return member
      end
    end

    def activity_logs(options = {})
      self.class.activity_logs.query(id, limit: 10, **options)
    end
  end
end
