module Subscriptions
  class Gap < Subscriptions::Base
    FIND_TENURE_GAP_PATH = "internal/tenureGap"
    POST_TENURE_GAP_PATH = "internal/fixTenureGap"

    attributes :StartTicket,
     :EndTicket,
     :DaysDiff

    def self.save(options = {})
      response = post POST_TENURE_GAP_PATH, params: options.as_json
      if response.success?
        from_attributes(response.body)
      else 
        from_errors(response.body["error"])
      end
    end

    def self.find(options = {})
      response = get FIND_TENURE_GAP_PATH, params: options.as_json
      if response.success?
        if response.body.length >= 1
          from_attributes(response.body[0])
        else
          from_attributes({})
        end
      else
        from_errors(response.body["error"])
      end
    end

    def save_params
      {
        startTicket: self.attributes[:StartTicket][:ID],
        endTicket: self.attributes[:EndTicket][:ID],
        daysDiff: self.attributes[:DaysDiff]
      }
    end
  end
end