module Subscriptions
  class Ticket < Subscriptions::Base
    STATUS_PATH = "internal/latestTicketTenureStatus"

    attributes :ticket_id,
     :updated,
     :access_end,
     :active

    def self.save(options = {})
      response = post STATUS_PATH, params: options.as_json
      if response.success?
        from_attributes(response.body)
      else 
        from_errors(response.body["error"] || "Unknown error from the tenure fix tool")
      end
    end

    def self.status(options = {})
      response = get STATUS_PATH, params: options.as_json
      if response.success?
        from_attributes(response.body)
      else
        from_errors(response.body["error"] || "Unknown error from the tenure fix tool")
      end
    end

    def save_params
      {
        userID: self.attributes[:User][:ID],
        channelID: self.attributes[:Channel][:ID]
      }
    end
  end
end