module Subscriptions
  class TicketProductRevenueConfig < Subscriptions::Base
    self.service_endpoint = Settings.valhalla.endpoint
    self.primary_attribute = :id

    attributes :id, :ticket_product_id, :start_date, :partner_rev_split_percent, :created_at, :updated_at

    def self.get_configs_for_ticket_product_id(ticket_product_id)
      response = get "/ticket_product_revenue_configs/#{ticket_product_id}"
      unless response.success?
        from_errors(response.body)
      end

      response.body["configs"].to_a.map do |rev_configs|
        from_attributes(rev_configs)
      end
    end

    def self.get_by_id(id)
      response = get "/ticket_product_revenue_configs/id/#{id}"
      if response.success? && response.body.is_a?(Hash)
        from_attributes(response.body)
      else
        from_errors(response.body)
      end
    end

    def self.update(id, start_date, rev_split)
      options = {
          id: id,
          start_date: start_date,
          rev_split: rev_split
      }
      response = patch "/ticket_product_revenue_configs", {
          body: options.to_json,
          headers: {"content-type" => "application/json"}
      }
      unless response.success? && response.body.is_a?(Hash)
        from_errors(response.body)
      end
      response
    end

    def self.delete(id)
      options = {
        id: id
      }
      response = post "/ticket_product_revenue_configs/delete", {
        body: options.to_json,
        headers: {"content-type" => "application/json"}
      }
      unless response.success? && response.body.is_a?(Hash)
        from_errors(response.body)
      end
      response
    end

    def self.create(ticket_product_id, start_date, rev_split)
      options = {
        ticket_product_id: ticket_product_id,
        start_date: start_date,
        partner_rev_split_percent: rev_split
      }
      response = post "/ticket_product_revenue_configs", {
          body: options.to_json,
          headers: {"content-type" => "application/json"}
      }
      unless response.success? && response.body.is_a?(Hash)
        from_errors(response.body)
      end
      response
    end
  end
end