module Subscriptions
  class Token < Subscriptions::Base
    self.service_endpoint = Settings.galleon.endpoint

    def self.get_token_balance(user_id)
      body = {
          user_id: user_id.to_s,
      }
      resp = post '/twirp/subs.Galleon/GetTokenBalance', {
          body: body.to_json,
          headers: { 'content-type' => 'application/json' }
      }
      return resp.body["balance"].nil? ? 0 : resp.body["balance"]
    end

    def self.grant_tokens_for_user(user_id, quantity)
      body = {
          owner_id: user_id,
          quantity: quantity,
      }

      resp = post '/twirp/subs.Galleon/GrantTokens', {
          body: body.to_json,
          headers: { 'content-type' => 'application/json' }
      }
      resp.success?
    end
  end
end
