module SupportTools
  RECOVERY_JOB_USER_BATCH_SIZE = 100

  class AccountRecovery < SupportTools::Base
    attributes :id, :reporter, :users

    validates :reporter, presence: true
    validates :users, length: { minimum: 1 }

    def save
      return false unless valid?

      users.each_slice(RECOVERY_JOB_USER_BATCH_SIZE) do |user_slice|
        AccountRecoveryJob.create(users: user_slice, reporter: self.reporter)
      end
    end
  end
end
