module Tmi
  class Chat < Tmi::Base
    def self.room_info(user_id)
      response = get "/rooms/#{user_id}"
      return {} unless response.success?
      return response.body["room"]
    end

    def self.chat_bans(user_id)
      response = get "/rooms/#{user_id}/bans"
      return {} unless response.success?
      return response.body
    end

    def self.chat_ip_abuse_status(remote_ip)
      return {} if remote_ip.blank?

      response = get "/internal/abuse/ip/#{remote_ip}/status"
      return {} unless response.success?
      return response.body
    end
  end
end
