module Twitch
  class GetGlobalPrivilegedUsersError < StandardError; end

  class GlobalPrivilegedUsers < Twitch::Base
    def self.get
      response = Twitch::Base.get('/global_privileged_users')
      raise GetGlobalPrivilegedUsersError unless response.success?

      {
        admins: response.body['admins'],
        subadmins: response.body['subadmins'],
        global_mods: response.body['global_mods']
      }
    end
  end
end
