module TwitchNami
  class Balance < TwitchNami::Base
    self.primary_attribute = :id
    attributes :user_balances

    def self.call(user_id)
      req = Twitch::Fulton::Example::Twitchnami::GetBalanceRequest.new(
        wallet_type: Twitch::Fulton::Example::Twitchnami::WalletType::GIFT_CARD,
        user_id: user_id
      )
      resp = twirp_client.get_balance(req)
      raise resp.error.msg if resp.error
      self.from_twirp_object(resp.data)
    end
  end
end
