module TwitchNami
  class Transact < TwitchNami::Base
    attributes :user_balance, :failure, :transaction_id

    def self.call(admin_user, user_id, operation, request_amount)
      require "securerandom"
      uuid = SecureRandom.uuid
      origin_id = "amzn1.twitch.gift_cards.admin_grant.#{uuid}"
      req = Twitch::Fulton::Example::Twitchnami::TransactRequest.new(
        wallet_type: Twitch::Fulton::Example::Twitchnami::WalletType::GIFT_CARD,
        user_id: user_id,
        operation: operation,
        request_amount: request_amount,
        ldap_email: admin_user.email,
        transaction_id: uuid,
        reason: "admin_panel",
        origin_id: origin_id
      )

      resp = twirp_client.transact(req)
      raise resp.error.msg if resp.error
      self.from_twirp_object(resp.data)
    end
  end
end
