module TwitchNami
  class WalletStatus < TwitchNami::Base
    attributes :failure

    def self.call(user_id, status)
      req = Twitch::Fulton::Example::Twitchnami::UpdateWalletStatusRequest.new(
        wallet_type: Twitch::Fulton::Example::Twitchnami::WalletType::GIFT_CARD,
        user_id: user_id,
        wallet_status: status
      )

      resp = twirp_client.update_wallet_status(req)
      raise resp.error.msg if resp.error
      self.from_twirp_object(resp.data)
    end
  end
end
