module UserRewards
  class BitsBadgeTier < Service::Base
    include Code::Justin::Tv::Commerce::Paydayrpc
    include Google::Protobuf

    self.service_endpoint = Settings.payday.admin_host.twirp_endpoint

    def self.twirp_client
      @twirp_client ||= PaydayClient.new(connection)
    end

    def self.grant_unlocked_rewards(user_id, channel_id)
      resp = twirp_client.admin_grant_unlocked_badge_tier_rewards(
        AdminGrantUnlockedBadgeTierRewardsReq.new(user_id: user_id, channel_id: channel_id)
      )

      raise resp.error.msg if resp.error
      resp.data.total_bits_cheered
    end

    def self.unlocked_emotes(user_id, channel_id)
      resp = twirp_client.get_bits_badge_tier_emotes(
        GetBitsBadgeTierEmotesReq.new(user_id: user_id, channel_id: channel_id)
      )

      raise resp.error.msg if resp.error

      emotes = resp.data.emotes.map do |twirp_emote|
        BitsBadgeTierEmote.from_twirp_object(twirp_emote)
      end

      emotes
    end
  end

  class BitsBadgeTierEmote < Service::Base
    include Code::Justin::Tv::Commerce::Paydayrpc

    attributes :emote_id, :emote_code, :emote_channel_id, :emote_group_id, :badge_tier_summary
  end

  class EmoteBitsBadgeTierSummary < Service::Base
    include Code::Justin::Tv::Commerce::Paydayrpc

    attributes :badge_tier_threshold, :is_emote_unlocked_for_user, :number_of_bits_until_unlock
  end
end
