module Vods
  class Channel < Vods::Base
    def self.find_for_user(options = {})
      page = options[:page].presence || 1
      query_params = {
        channel_id: options[:id].to_s,
        offset: (page.to_i - 1) * PER_PAGE,
        limit: PER_PAGE
      }

      query_params[:broadcast_types] = [options[:broadcast_type].upcase] if options[:broadcast_type].present?

      begin
        response = twirp_client.internal_get_vods_by_user_include_banned_users(query_params)
      rescue Faraday::ClientError => e
        return from_errors(['Vod Search for UserID failed', e])
      else
        return from_errors(['Vod Search for UserID failed', response.error.msg]) if response.error

        vods = response.data.vods.map do |vod|
          Vods::Vod.from_twirp_object(vod)
        end
      end

      paginate vods, per_page: PER_PAGE, total_count: response.data.total_count
    end
  end
end
