module Vods
  class TrackAppeal < Vods::Base
    attributes :track_appeal_id, :audible_magic_response_id,
               :vod_appeal_id, :reason, :created_at,
               :updated_at, :resolved_at

    alias id track_appeal_id

    def self.find(id, _options = {})
      from_attributes(track_appeal_id: id)
    end

    def resolve(action)
      response = self.class.twirp_client.resolve_track_appeal(track_appeal_id: id, action: action)
      raise response.error.msg if response.error
      response
    end
  end
end
