module Vods
  class UserVodPrivacyProperty < Vods::Base
    attributes :channel_id, :hide_archives, :hide_archives_enabled, :created_at, :updated_at

    def self.find(channel_id)
      begin
        response = twirp_client.internal_get_user_video_privacy_properties(channel_id: channel_id.to_s)
      rescue Faraday::ClientError => e
        return from_errors(['VodPrivacy Property Lookup failed', e])
      else
        return from_errors(['VodPrivacy Property Lookup failed', response.error.msg]) if response.error
      end
      from_twirp_object response.data
    end

    def save
      response = self.class.twirp_client.internal_update_user_video_privacy_properties(update_attributes)
      if response.error
        self.errors = response.error.msg
        return false
      end

      true
    end

    def hide_archives
      self.class.booleanize @hide_archives
    end

    def hide_archives_enabled
      self.class.booleanize @hide_archives_enabled
    end

    def update_attributes
      {
        channel_id: channel_id,
        hide_archives: Google::Protobuf::BoolValue.new(value: hide_archives),
        hide_archives_enabled: Google::Protobuf::BoolValue.new(value: hide_archives_enabled),
      }
    end
  end
end
