module Vods
  class UserVodProperty < Vods::Base
    attributes :channel_id, :save_vods_forever, :vod_storage_days, :can_upload_vod, :youtube_exporting_disabled, :skip_upload_moderation, :skip_muting, :can_upload_unlimited, :created_at, :updated_at

    def self.find(channel_id)
      begin
        response = twirp_client.get_user_vod_properties(channel_id: channel_id.to_s)
      rescue Faraday::ClientError => e
        return from_errors(['Vod Property Lookup failed', e])
      else
        return from_errors(['Vod Property Lookup failed', response.error.msg]) if response.error
      end
      from_twirp_object response.data
    end

    def save
      response = self.class.twirp_client.internal_update_user_vod_properties(update_attributes)
      if response.error
        self.errors = response.error.msg
        return false
      end

      true
    end

    def save_vods_forever
      self.class.booleanize @save_vods_forever
    end

    def skip_upload_moderation
      self.class.booleanize @skip_upload_moderation
    end

    def can_upload_unlimited
      self.class.booleanize @can_upload_unlimited
    end

    def skip_muting
      self.class.booleanize @skip_muting
    end

    def update_attributes
      {
        channel_id: channel_id,
        save_vods_forever: Google::Protobuf::BoolValue.new(value: save_vods_forever),
        skip_upload_moderation: Google::Protobuf::BoolValue.new(value: skip_upload_moderation),
        can_upload_unlimited: Google::Protobuf::BoolValue.new(value: can_upload_unlimited),
        skip_muting: Google::Protobuf::BoolValue.new(value: skip_muting),
      }
    end
  end
end
