module Vods
  class VodAppeal < Vods::Base
    PER_PAGE = 25

    attributes :vod_appeal_id, :resolved_at, :created_at, :updated_at,
               :vod_id, :priority, :full_name, :street_address1,
               :street_address2, :city, :state, :zipcode, :country

    alias id vod_appeal_id

    def self.all(options = {})
      page = options[:page].presence || 1
      scope = options[:scope].presence || "partner"
      filter = options[:filter].presence || {}

      query_params = {
        priority: Google::Protobuf::BoolValue.new(value: scope == "partner"),
        resolved: Google::Protobuf::BoolValue.new(value: scope == "resolved"),
        offset: (page.to_i - 1) * PER_PAGE,
        limit: PER_PAGE
      }

      query_params[:vod_id] = filter[:vod_id] if filter[:vod_id].present?
      query_params[:user_info] = filter[:user_info] if filter[:user_info].present?

      response = twirp_client.get_vod_appeals(query_params)
      raise response.error.msg if response.error

      vod_appeals = response.data.appeals.map do |vod_appeals_attributes|
        self.from_twirp_object(vod_appeals_attributes)
      end

      paginate vod_appeals, per_page: PER_PAGE, total_count: response.data.total_count
    end

    def self.find(id, _options = {})
      from_attributes(vod_appeal_id: id)
    end

    def resolve
      self.class.twirp_client.resolve_vod_appeal(vod_appeal_id: id)
    end
  end
end
