module Zuma
  class UserBlock < Zuma::Base
    self.primary_attribute = :id

    attributes :id,
      :blocked_user_ids,
      :is_blocked

    validates :blocked_user_ids, :is_blocked, presence: true

    def self.all(id)
      return [] if id.blank?

      body = {
        user_id: id.to_s
      }

      response = post("/v1/users/blocks/get", body: body.to_json)
      if response.success?
        if response.body["blocked_user_ids"].nil?
          []
        else
          from_attributes(response.body)
        end
      else
        []
      end
    end

    def self.find(id, other_user_id)
      body = {
        user_id: id.to_s,
        blocked_user_id: other_user_id.to_s
      }

      response = post("/v1/users/blocks/is_blocked", body: body.to_json)
      if response.success?
        from_attributes(response.body)
      end
    end

  end
end
