require File.expand_path('../boot', __FILE__)

require "rails"
# Pick the frameworks you want:
require "active_model/railtie"
require "active_job/railtie"
require "action_controller/railtie"
require "action_mailer/railtie"
require "action_view/railtie"
require "action_cable/engine"
require "sprockets/railtie"
require "rails/test_unit/railtie"
require_relative "../lib/middleware/activity_log"
require_relative "../lib/log_formatter"

# Require the gems listed in Gemfile, including any gems
# you've limited to :test, :development, or :production.
Bundler.require(*Rails.groups)

module Administer
  class Application < Rails::Application
    config.autoload_paths << "#{Rails.root}/lib"
    config.autoload_paths << "#{Rails.root}/app/services"
    config.eager_load_paths << "#{Rails.root}/lib/geoip"
    config.eager_load_paths << "#{Rails.root}/lib/tracking"
    config.eager_load_paths << "#{Rails.root}/lib/translate"
    config.active_job.queue_adapter = :sucker_punch
    config.middleware.use Middleware::ActivityLog
    config.log_formatter = JSONFormatter.new
  end
end

require "settings"
