require_dependency "net_http_socks5_compat"

Rollbar.configure do |config|
  config.access_token = Settings.secrets.rollbar_token

  config.enabled = !Rails.env.in?(["development", "test"])

  config.person_id_method = 'ldap_login'
  config.person_username_method = 'ldap_login'
  config.person_email_method = 'email'

  config.scrub_fields |= [:_csrf_token, :'osiris-token']
  config.scrub_headers |= ["osiris-token", "Referer"]

  config.use_sucker_punch

  config.environment = ENV['ROLLBAR_ENV'] || Rails.env
end

Raven.configure do |config|
  # custom adapter that supports socks5 proxies for local development - this is was service/base uses as well
  if Rails.env.starts_with?('development')
    config.http_adapter = :net_http_socks_compat
    config.proxy = Settings.proxy
  end

  config.dsn = "https://#{Settings.secrets.chaos.sentry.client_id}:#{Settings.secrets.chaos.sentry.client_secret}@#{Settings.chaos.sentry.endpoint}/5"

  config.sanitize_fields = Rails.application.config.filter_parameters.map(&:to_s)
  config.sample_rate = 1.0

  config.open_timeout = Service::Base::OPEN_TIMEOUT
  config.timeout = Service::Base::READ_TIMEOUT

  config.async = lambda { |event|
    ErrorReportJob.perform_async(event)
  }

  config.transport_failure_callback = lambda { |event|
    Rails.logger.error(event)
  }
end
