ActiveSupport::Notifications.subscribe "process_action.action_controller" do |_, started, finished, _, data|
  url_string = data[:path].split('?')
  path = url_string[0]
  query = url_string[1]
  rails_controller = "#{data[:controller]}/#{data[:action]}"

  Rails.logger.info({
    _type: "admin_panel_request",
    access_date: started,
    latency: finished - started,
    url_path: path,
    url_query: query,
    rails_controller: rails_controller,
    method: data[:method],
    url_host: data[:headers]['HTTP_HOST'],
    url_scheme: 'https',
    response_status: data[:status]
  }.to_json)
end
