require 'action_dispatch/middleware/session/dalli_store'

module ActionDispatch
  module Session
    class DalliStore < AbstractStore
      alias_method :find_session, :get_session
      alias_method :write_session, :set_session
    end
  end
end

module Administer
  class SessionStore
    SESSION_KEY = "_admin_panel_session_id"
    SESSION_NAMESPACE = [Rails.env, "session"].join("-").freeze

    class << self
      def session_options
        {
          key: SESSION_KEY,
          namespace: SESSION_NAMESPACE,
          memcache_server: Settings.memcached.shards,
          expire_after: 12.hours,
        }
      end

      def configure!
        Rails.application.config.session_store :dalli_store, session_options
      end
    end
  end
end

Administer::SessionStore.configure!
