# Contribution Guidelines

## Submitting a PR

- branch from `dev` and make your changes.
- add relevant [tracking events](tracking.md) for your feature.
- open a PR to merge into `dev`.
- make sure there is at least 80% coverage of your new changes. [codecov] PR
  merge policy will require this.
- add relevant screen shots of your changes if there are UI changes.
- request approval for your feature.
- add the [`ready for review`](/admin-services/admin-panel/pulls?q=is%3Apr+is%3Aopen+label%3A%22ready+for+review%22) label when you're ready for input.

Once the above is complete, we'll merge it into `dev` prior to the next release cut, and your changes will be deployed to staging automatically via Jenkins.

Admins of this project will request changes for:

- Location of page - does this page belong in a better place?
- Permissions of the page - does this page have proper authorization for
  buttons?

## Release Cycle

Each Monday, we will cut a `release/<target-date>` branch from `dev`. This is
deployed automatically to the canary environment via Jenkins.

- All developers who contributed since the last release will be assigned to
  approve the PR. This includes manually end-to-end testing the feature in
  canary.
- If you don't approve the release, your change _may not_ make it into the
  release cycle and will be delayed a week depending on the complexity of the
  change.
- The following Monday, this release will be merged into `master` and deployed
  to production via Jenkins.
- `master` will be merged into `dev`.

## Automatically Deployed Environments

| Environment | Commit to Branch   | Twitch Backends | URL                                            |
| ----------- | ------------------ | --------------- | ---------------------------------------------- |
| staging     | `dev` or `chore/*` | staging         | https://admin-panel-staging.internal.justin.tv |
| canary      | `release/*`        | production      | https://admin-panel-canary.internal.justin.tv  |
| production  | `master`           | production      | https://admin-panel.internal.justin.tv         |

[codecov]: http://codecov.internal.justin.tv
