module Admin
  class GeneratorBase < Rails::Generators::NamedBase
    protected

    def assign_names!(name)
      @module_parts = name.split(/::|\//).map &:camelize
      @module_parts << "Item" if @module_parts.length < 2
      name = @module_parts.pop

      super(name)
    end

    def singularized_name
      singular_name.singularize
    end

    def pluralized_name
      singular_name.pluralize
    end

    def simple_class_name
      singularized_name.camelize
    end

    def module_variable_name
      @module_parts.map(&:underscore).join("_")
    end

    def module_path
      @module_parts.map(&:underscore).join("/")
    end

    def module_name
      @module_parts.join("::")
    end

    def full_class_name
      (@module_parts + [simple_class_name]).join("::")
    end
  end
end
