module Admin
  class ScaffoldGenerator < Admin::GeneratorBase
    class_option :service, type: :boolean, default: true

    argument :attributes, type: :array, default: [], banner: "attribute1 attribute2 attribute3"

    hook_for :scaffold_controller, required: true do |invoked|
      invoke invoked, [ full_class_name, *attributes.map(&:name) ]
    end

    hook_for :service do |invoked|
      invoke invoked, [ full_class_name, *attributes.map(&:name) ]
    end
  end
end
