module Admin
  class ScaffoldControllerGenerator < Admin::GeneratorBase
    source_root File.expand_path('../templates', __FILE__)

    check_class_collision suffix: "Controller"

    class_option :helper, type: :boolean, default: true
    class_option :views, type: :boolean, default: true
    class_option :resource_route, type: :boolean, default: true
    class_option :policy, type: :boolean, default: true

    argument :attributes, type: :array, default: [], banner: "attribute1 attribute2 attribute3"

    def create_controller_file
      base_path = "app/controllers/#{module_path}/base_controller.rb"
      path = "app/controllers/#{module_path}/#{controller_name}_controller.rb"

      template "base.rb", base_path unless File.exists?(base_path)
      template "controller.rb", path
    end

    hook_for :resource_route
    hook_for :views
    hook_for :helper
    hook_for :policy

    private

    def controller_name
      pluralized_name
    end

    def controller_class_name
      controller_name.camelize
    end
  end
end
