module Admin
  class ServiceGenerator < Admin::GeneratorBase
    source_root File.expand_path('../templates', __FILE__)
    argument :attributes, type: :array, default: [], banner: "attribute1 attribute2 attribute3"

    def copy_service_file
      prefix = File.join "app", "services", module_path
      path = File.join prefix, "#{file_name}.rb"
      base_path = File.join prefix, "base.rb"

      template "base.rb", base_path unless File.exists?(base_path)
      template "service.rb", path
    end
  end
end
