class IpGeo
  attr_accessor :country, :country_code, :region, :city, :latitude, :longitude, :accuracy_radius, :isp
  COUNTRY = 'Country'
  COUNTRY_CODE = 'Country Code'
  REGION = 'Region'
  CITY = 'City'
  LATITUDE = 'Latitude'
  LONGITUDE = 'Longitude'
  ACCURACY_RADIUS = 'Accuracy Radius'
  ISP = 'ISP'

  # rubocop:disable Metrics/ParameterLists
  def initialize(country, country_code, region, city, latitude, longitude, accuracy_radius, isp)
    @country = country
    @country_code = country_code
    @region = region
    @city = city
    @latitude = latitude
    @longitude = longitude
    @accuracy_radius = accuracy_radius
    @isp = isp
  end
  # rubocop:enable Metrics/ParameterLists

  def fields
    return {
        COUNTRY => @country,
        COUNTRY_CODE => @country_code,
        REGION => @region,
        CITY => @city,
        LATITUDE => @latitude,
        LONGITUDE => @longitude,
        ACCURACY_RADIUS => @accuracy_radius,
        ISP => @isp
    }
  end

  def self.from_maxmind(geo_lookup, isp_lookup)
    country = geo_lookup.country.name
    country_code = geo_lookup.country.iso_code
    region = geo_lookup.subdivisions.most_specific.name
    city = geo_lookup.city.name
    latitude = geo_lookup.location.latitude
    longitude = geo_lookup.location.longitude
    accuracy_radius = geo_lookup.location.accuracy_radius
    isp = isp_lookup['isp']

    return IpGeo.new(country, country_code, region, city, latitude, longitude, accuracy_radius, isp)
  end
end
