module ResqueJobs
  class Worker
    include ActiveModel::Model

    attr_accessor :id, :hostname, :job

    def self.all
      workers = Resque::Worker.all
      workers.map { |w| new(id: w.id, hostname: w.hostname, job: w.job) }
    end

    def job_status
      @status ||= job_id ? Resque::Plugins::Status::Hash.get(job_id) : nil
      @status
    end

    def status
      job_status ? job_status.status : nil
    end

    def job_id
      job.blank? ? nil : job['payload']['args'][0]
    end

    def job_started
      job_status ? Time.at(job_status.time) : nil
    end
  end
end
