module Service
  class Proxy
    PER_PAGE = 10
    CHAINED_METHODS = %w{order page per_page}
    ALL_CHAINED_METHODS = %w{where} + CHAINED_METHODS

    CHAINED_METHODS.each do |mtd|
      define_method mtd do |new_value|
        @internal_options[mtd.to_sym] = new_value
        self
      end
    end

    def where(new_where)
      @internal_options[:where].merge!(new_where)
      self
    end

    def initialize(base)
      @base = base
      @internal_options = {
        where: {},
        page: 1,
        per_page: PER_PAGE,
      }
    end

    def all(options = {})
      @base.all options.merge(@internal_options).with_indifferent_access
    end
  end
end
