module Service
  class Response < SimpleDelegator
    def initialize(http_response = {})
      super(http_response)
      @http_response = http_response
    end

    def body
      @body ||= JSON.parse(super) rescue super
    end

    delegate :__get_object__, to: :http_response
  end
end
