package main

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

// properties of a command string
// given a string
// split by fields
// for each field
// --if the field starts with " or ', it must end with the same character.
// --it can contain spaces
// -if the field does not start with " or ', it must not end with the same character.
// --it cannot contain spaces

func stringPointifier(s string) *string {
	return &s
}

func stringArrayPointifier(stringArray []string) []*string {

	pointers := make([]*string, len(stringArray))

	for i, v := range stringArray {
		pointers[i] = stringPointifier(v)
	}

	return pointers
}

func Test_createCommandString(t *testing.T) {
	assert.Exactly(t,
		createCommandString("bundle exec puma -w 4 -p 8000"),
		stringArrayPointifier([]string{"bundle", "exec", "puma", "-w", "4", "-p", "8000"}))
	assert.Exactly(t,
		createCommandString("sh -c '. ./scripts/download-maxmind.sh && exec bundle exec puma -w 4 -p 8000'"),
		stringArrayPointifier([]string{"sh", "-c", "'. ./scripts/download-maxmind.sh && exec bundle exec puma -w 4 -p 8000'"}))
}
