require 'rails_helper'

RSpec.describe BannedWords::ItemsController do

  include_context 'mocked permissions'

  let(:permission) { 'global_banned_words' }

  describe 'index' do
    describe 'permissions' do
      let(:action) { :index }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          expect(BannedWords::Item).to receive(:all).and_return([])
          get action
        end

        it_behaves_like 'it returns a success response'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          get action
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

  end

  describe 'new' do
    describe 'permissions' do
      let(:action) { :new }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          get action, :params => {:banned_words_item => {:word => 'lel', :can_opt_out => 'false'}}
        end

        it_behaves_like 'it returns a success response'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          get action, :params => {:banned_words_item => {:word => 'lel', :can_opt_out => 'false'}}
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

  end

  describe 'create' do
    describe 'permissions' do
      let(:action) { :create }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          expect_any_instance_of(BannedWords::Item).to receive(:save).and_return(true)
          post action, :params => {:banned_words_item => {:word => 'lel', :can_opt_out => 'false'}}
        end

        it_behaves_like 'it redirects the user and displays a success message'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          post action, :params => {:banned_words_item => {:word => 'lel', :can_opt_out => 'false'}}
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end
  end

  describe 'destroy' do
    describe 'permissions' do
      let(:action) { :destroy }
      let(:dummy_item) { BannedWords::Item.new }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          expect(BannedWords::Item).to receive(:from_attributes).with({:word => 'lel'}).and_return(dummy_item)
          expect_any_instance_of(BannedWords::Item).to receive(:destroy).and_return(true)
          post action, :params => {:id => 'lel'}
        end

        it_behaves_like 'it redirects the user and displays a success message'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          expect(BannedWords::Item).to receive(:from_attributes).with({:word => 'lel'}).and_return(dummy_item)
          post action, :params => {:id => 'lel'}
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

  end
end
