require "rails_helper"

RSpec.describe BeefCake::UsersController do
  include_context "mocked permissions"

  let(:permission) { "admin_permissions" }
  let(:login_name) { "ali.anwar"}
  let(:ldap_user) { BeefCake::User.new(ldap_login: login_name, active: true) }

  describe "index" do
    context "a user with appropriate users" do
      include_context "an authorized user"

      before do
        expect(BeefCake::User).to receive(:all).and_return([])
        get :index
      end

      it_behaves_like "it returns a success response"
    end

    context "a user without appropriate users" do
      include_context "an unauthorized user"

      before do
        get :index
      end

      it_behaves_like "it redirects the user and displays an error"
    end
  end

  describe "edit" do
    context "a user with appropriate users" do
      include_context "an authorized user"

      before do
        expect(BeefCake::User).to receive(:find).with(login_name).and_return(ldap_user)
        get :edit, params: {id: login_name}
      end

      it_behaves_like "it returns a success response"
    end

    context "a user without appropriate users" do
      include_context "an unauthorized user"

      before do
        expect(BeefCake::User).to receive(:find).with(login_name).and_return(ldap_user)
        get :edit, params: {id: login_name}
      end

      it_behaves_like "it redirects the user and displays an error"
    end
  end

  describe "update" do
    context "a user with appropriate users" do
      include_context "an authorized user"

      before do
        expect(BeefCake::User).to receive(:find).with(login_name).and_return(ldap_user)
        expect(ldap_user).to receive(:save).and_return(true)
        post :update, params: {id: login_name, beef_cake_user: {role_ids: [1, 2, 3]}}
      end

      it_behaves_like "it redirects the user and displays a success message"
    end

    context "a user without appropriate users" do
      include_context "an unauthorized user"

      before do
        expect(BeefCake::User).to receive(:find).with(login_name).and_return(ldap_user)
        post :update, params: {id: login_name, beef_cake_user: {role_ids: [1, 2, 3]}}
      end

      it_behaves_like "it redirects the user and displays an error"
    end
  end

  describe "reactivate" do
    context "a user with appropriate users" do
      include_context "an authorized user"

      before do
        expect(BeefCake::User).to receive(:find).with(login_name).and_return(ldap_user)
        expect(ldap_user).to receive(:reactivate).and_return(true)
        put :reactivate, params: {id: login_name}
      end

      it_behaves_like "it redirects the user and displays a success message"
    end

    context "a user without appropriate users" do
      include_context "an unauthorized user"

      before do
        expect(BeefCake::User).to receive(:find).with(login_name).and_return(ldap_user)
        put :reactivate, params: {id: login_name}
      end

      it_behaves_like "it redirects the user and displays an error"
    end
  end
end
