require 'rails_helper'

RSpec.describe Bits::ActualsController do
  include_context 'mocked permissions'

  let(:permission) { ['revenue_reporting', 'bits_catalog'] }

  describe 'index' do
    context 'a user without permission' do
      include_context 'an unauthorized user'

      before do
        get :index
      end

      it_behaves_like 'it redirects the user and displays an error'
    end

    context 'a user with permission' do
      include_context 'an authorized user'

      let(:permission) { ['revenue_reporting'] }

      before do
        expect(Bits::Actual).to receive(:all).and_return(double(success?: true, status: 200, body: {'actuals' => []}))
        get :index
      end

      it_behaves_like 'it returns a success response'
    end
  end

  describe 'configure_actuals' do
    context 'a user without permission' do
      include_context 'an unauthorized user'

      before do
        post :configure_actuals, params: {monthyear: '11-2019', platforim: 'IOS', actuals: []}
      end

      it_behaves_like 'it redirects the user and displays an error'
    end

    context 'a request missing month_year' do
      include_context 'an authorized user'

      let(:permission) { ['revenue_reporting'] }

      before do
        post :configure_actuals, params: {platform: 'IOS', actuals: { 'bit-type' => '123' }}
      end

      it_behaves_like 'it redirects the user and displays an error'
    end

    context 'a request with an invalid month_year' do
      include_context 'an authorized user'

      let(:permission) { ['revenue_reporting'] }

      before do
        post :configure_actuals, params: {month_year: 'invalid-month-year', platform: 'IOS', actuals: { 'bit-type' => '123' }}
      end

      it_behaves_like 'it redirects the user and displays an error'
    end

    context 'a request missing platform' do
      include_context 'an authorized user'

      let(:permission) { ['revenue_reporting'] }

      before do
        post :configure_actuals, params: {month_year: 'invalid-month-year', actuals: { 'bit-type' => '123' }}
      end

      it_behaves_like 'it redirects the user and displays an error'
    end

    context 'a request with an invalid platform' do
      include_context 'an authorized user'

      let(:permission) { ['revenue_reporting'] }

      before do
        post :configure_actuals, params: {month_year: 'invalid-month-year', platform: 'WINDOWS_PHONE', actuals: { 'bit-type' => '123' }}
      end

      it_behaves_like 'it redirects the user and displays an error'
    end

    context 'a request missing actuals' do
      include_context 'an authorized user'

      let(:permission) { ['revenue_reporting'] }

      before do
        post :configure_actuals, params: {month_year: 'invalid-month-year', platform: 'WINDOWS_PHONE'}
      end

      it_behaves_like 'it redirects the user and displays an error'
    end

    context 'a valid request' do
      include_context 'an authorized user'

      let(:permission) { ['revenue_reporting'] }

      before do
        expect(Bits::Actual).to receive(:configure).and_return(double(success?: true, status: 200))
        post :configure_actuals, params: {month_year: '11-2019', platform: 'IOS', actuals: { 'bit-type' => '123' }}
      end

      it_behaves_like 'it redirects the user and displays a success message'
    end
  end
end
