require 'rails_helper'

RSpec.describe ContentTag::ChannelTagsController do
  include_context 'mocked permissions'
  let(:permission) { 'content_tag' }

  describe 'index' do
    let(:action) { :index }

    describe 'permissions' do
      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          get action
        end

        it_behaves_like 'it returns a success response'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          get action
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end
  end

  describe 'add_channel_tag' do
    let(:action) { :add_channel_tag }
    context 'a user with appropriate permissions' do
      include_context 'an authorized user'

      let(:test_channel_tag) { ContentTag::ChannelTag.new(channel_id: "test_tag_id") }
      before do
        allow(ContentTag::ChannelTag).to receive(:find)
          .and_return(test_channel_tag)
        allow(test_channel_tag).to receive(:add_channel_tag)
          .and_return(true)
      end
      it 'creates a channel tag' do
        response = patch action, params: { id: "test_tag_id", content_tag_channel_tag: { id: "test_tag_id"} }
        expect(response.code).to eq('302')
        expect(flash[:success]).to be_present
      end
    end
  end

  describe 'delete_channel_tag' do
    let(:action) { :delete_channel_tag }
    context 'a user with appropriate permissions' do
      include_context 'an authorized user'

      let(:test_channel_tag) { ContentTag::ChannelTag.new(channel_id: "test_tag_id") }
      before do
        allow(ContentTag::ChannelTag).to receive(:find)
          .and_return(test_channel_tag)
        allow(test_channel_tag).to receive(:delete_channel_tag)
          .and_return(true)
      end
      it 'creates a channel tag' do
        response = get action, params: { id: "test_tag_id", content_tag_channel_tag: { id: "test_tag_id"} }
        expect(response.code).to eq('302')
        expect(flash[:success]).to be_present
      end
    end
  end

end
