require 'rails_helper'

RSpec.describe Dmca::UsersController do

  include_context 'mocked permissions'

  let(:permission) { 'dmca_copyright_holders' }

  describe 'index' do
    describe 'permissions' do
      let(:action) { :index }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          get action
        end

        it_behaves_like 'it returns a success response'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          get action
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

  end

  describe 'show' do
    describe 'permissions' do
      let(:action) { :show }
      let(:dummy_item) { Dmca::User.new }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          expect(Dmca::User).to receive(:find).with('foo').and_return(dummy_item)
          get action, :params => {:id => 'foo'}
        end

        it_behaves_like 'it returns a success response'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          expect(Dmca::User).to receive(:find).with('foo').and_return(dummy_item)
          get action, :params => {:id => 'foo'}
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

  end

  describe 'create' do
    describe 'permissions' do
      let(:action) { :create }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          expect_any_instance_of(Dmca::User).to receive(:save).and_return(true)
          post action, :params => {:dmca_user => {:user_id => '109657733', :email => 'jday@twitch.tv', :company => 'Twitch', :address => '225 Bush St', :phone_number => '555-555-5555'}}
        end

        it_behaves_like 'it redirects the user and displays a success message'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          post action, :params => {:dmca_user => {:user_id => '109657733', :email => 'jday@twitch.tv', :company => 'Twitch', :address => '225 Bush St', :phone_number => '555-555-5555'}}
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

  end

  describe 'destroy' do
    describe 'permissions' do
      let(:action) { :destroy }
      let(:dummy_item) { Dmca::User.new(:user_id => '109657733') }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          expect(Dmca::User).to receive(:find).and_return(dummy_item)
          expect(dummy_item).to receive(:destroy).and_return(true)
          delete action, :params => {:id => '109657733'}
        end

        it_behaves_like 'it redirects the user and displays a success message'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          expect(Dmca::User).to receive(:find).and_return(dummy_item)
          delete action, :params => {:id => '109657733'}
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

  end
end
