require "rails_helper"

RSpec.describe Games::AddCategoriesController do
  include_context 'mocked permissions'
  include_context 'an authorized user'
  let(:permission) { 'games' }

  describe "create" do
    let(:add_category_service) do
      Games::AddCategory.from_attributes(igdb_id: "igdb-id-123")
    end

    context "create-success" do
      let(:action) { :create }

      let(:add_response) do
        Twitchcategoryindexer::SyncIGDBCategoryResponse.new(categoryID: 123)
      end

      before do
        expect(Games::AddCategory).to receive(:new).and_return(add_category_service)
        expect(add_category_service).to receive(:save).and_return(add_response)
        post action, params: {games_add_category: { igdb_id: 1234 }}
      end

      it "successful igdb category create" do
        expect(flash[:success]).to be_present

      end
    end

    context "create-failed" do
      let(:action) { :create }

      before do
        expect(Games::AddCategory).to receive(:new).and_return(add_category_service)
        expect(add_category_service).to receive(:save).and_raise("some_error")
        post action, params: {games_add_category: { igdb_id: 1234 }}
      end

      it "failed igdb category create" do
        expect(flash[:danger]).to be_present
      end
    end

  end

end
