require 'rails_helper'

RSpec.describe Graffiti::CreateTagsController do
  include_context 'mocked permissions'

  let(:permission) { 'graffiti' }

  describe 'index' do
    let(:action) { :index }

    describe 'permissions' do
      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          get action
        end

        it_behaves_like 'it returns a success response'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          get action
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end
  end

  describe 'create' do
    let(:action) { :create }
    let(:test_tag_name) { 'test_tag' }
    let(:test_tag) { Graffiti::CreateTag.new(name: test_tag_name) }

    describe 'a tag' do
      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          allow(Graffiti::CreateTag).to receive(:new)
            .and_return(test_tag)
          allow(test_tag).to receive(:save)
            .and_return(true)
        end

        it 'creates a tag' do
          response = get action, :params => {:graffiti_create_tag => {:name => test_tag_name}}
          expect(response.code).to eq('302')
          expect(flash[:success]).to be_present
        end
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        it 'fails to create a tag' do
          get action, :params => {:graffiti_create_tag => {:name => test_tag_name}}
          expect(flash[:error]).to be_present
        end
      end
    end
  end
end
