require 'rails_helper'

describe HealthController do
  describe 'status' do
    let(:action) { :status }
    let(:expected_health_status) { 200 }

    before(:each) do
      expect(BeefCake::Health).to receive(:status).and_return(beefcake_status)
      expect(Service::S2S.instance.client).to receive(:healthy?).and_return(s2s_status)
      response = get action
      expect(response.status).to eql(expected_health_status)
    end

    describe 's2s and beefcake available' do
      let(:beefcake_status) { true }
      let(:s2s_status) { true }
      let(:expected_health_status) { 200 }

      it 'should return 200 if beefcake and s2s are available' do
      end
    end

    describe 's2s available beefcake unavailable' do
      let(:beefcake_status) { false }
      let(:s2s_status) { true }
      let(:expected_health_status) { 500 }

      it 'should return 500 if beefcake and s2s are available' do
      end
    end

    describe 'beefcake available s2s unavailable' do
      let(:beefcake_status) { true }
      let(:s2s_status) { false }
      let(:expected_health_status) { 500 }

      it 'should return 500 if beefcake and s2s are available' do
      end
    end
  end
end
