require 'rails_helper'

RSpec.describe Keys::ProductTypesController do
  include_context 'mocked permissions'

  let(:permission) { 'product_key_generation' }

  let(:test_product_type) { 'test-product-type' }
  let(:test_sns_topic) { 'test-sns-topic' }
  let(:test_description) { 'test-description' }

  describe 'index' do
    context 'a user without permission' do
      include_context 'an unauthorized user'

      before do
        get :index
      end

      it_behaves_like 'it redirects the user and displays an error'
    end

    context 'a user with permission' do
      include_context 'an authorized user'

      before do
        expect(Keys::ProductType).to receive(:all).and_return(double(success?: true, status: 200, body: {'product_types' => []}))
        get :index
      end

      it_behaves_like 'it returns a success response'
    end
  end

  describe 'create' do
    context 'a user without permission' do
      include_context 'an unauthorized user'

      before do
        post :create
      end

      it_behaves_like 'it redirects the user and displays an error'
    end

    context 'a user with permission' do
      include_context 'an authorized user'
      let(:product_type) { Keys::ProductType.new }

      before do
        expect(Keys::ProductType).to receive(:new).and_return(product_type)
        expect(product_type).to receive(:create).and_return(double(success?: true, status: 200))
        post :create, params: { keys_product_type: { product_type: test_product_type, sns_topic: test_sns_topic, description: test_description } }
      end

      it_behaves_like 'it redirects the user and displays a success message'
    end
  end
end
