require 'rails_helper'

RSpec.describe Keys::ProductsController do
  include_context 'mocked permissions'

  let(:permission) { 'product_key_generation' }

  let(:test_product_type) { 'test-product-type' }
  let(:test_sku) { 'test-sku' }
  let(:test_description) { 'test-description' }

  describe 'index' do
    context 'a user without permission' do
      include_context 'an unauthorized user'

      before do
        get :index
      end

      it_behaves_like 'it redirects the user and displays an error'
    end

    context 'a user with permission' do
      include_context 'an authorized user'

      before do
        expect(Keys::Product).to receive(:all).and_return(double(success?: true, status: 200, body: {'product' => []}))
        get :index, params: { product_type: test_product_type }
      end

      it_behaves_like 'it returns a success response'
    end
  end

  describe 'create' do
    context 'a user without permission' do
      include_context 'an unauthorized user'

      before do
        post :create
      end

      it_behaves_like 'it redirects the user and displays an error'
    end

    context 'a user with permission' do
      include_context 'an authorized user'
      let(:product) { Keys::Product.new }

      before do
        expect(Keys::Product).to receive(:new).and_return(product)
        expect(product).to receive(:create).and_return(double(success?: true, status: 200))
        post :create, params: { keys_product: { product_type: test_product_type, sku: test_sku, description: test_description } }
      end

      it_behaves_like 'it redirects the user and displays a success message'
    end
  end

end
