require 'rails_helper'

RSpec.describe Notifications::ItemsController do

  include_context 'mocked permissions'

  let(:permission) { 'notifications' }

  describe 'index' do
    describe 'permissions' do
      let(:action) { :index }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          expect(Notifications::Item).to receive(:all).and_return([])
          get action
        end

        it_behaves_like 'it returns a success response'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          get action
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

  end

  describe 'new' do
    describe 'permissions' do
      let(:action) { :new }
      let(:dummy_item) { Notifications::Item.new }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          get action, :params => {:id => 'foo', :notifications_item => {:group_name => 'dude'}}
        end

        it_behaves_like 'it returns a success response'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          get action, :params => {:id => 'foo', :notifications_item => {:group_name => 'dude'}}
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

  end

  describe 'create' do
    describe 'permissions' do
      let(:action) { :create }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          expect_any_instance_of(Notifications::Item).to receive(:save).and_return(true)
          post action, :params => {:id => 'foo', :notifications_item => {:group_name => 'dude'}}
        end

        it_behaves_like 'it redirects the user and displays a success message'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          post action, :params => {:id => 'foo', :notifications_item => {:group_name => 'dude'}}
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end
  end

  describe 'edit' do
    describe 'permissions' do
      let(:action) { :edit }
      let(:dummy_item) { Notifications::Item.new }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          expect(Notifications::Item).to receive(:find).with('foo').and_return(dummy_item)
          get action, :params => {:id => 'foo'}
        end

        it_behaves_like 'it returns a success response'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          expect(Notifications::Item).to receive(:find).with('foo').and_return(dummy_item)
          get action, :params => {:id => 'foo'}
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

  end

  describe 'update' do
    describe 'permissions' do
      let(:action) { :update }
      let(:dummy_item) { Notifications::Item.new }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          expect(Notifications::Item).to receive(:find).with('foo').and_return(dummy_item)
          expect(dummy_item).to receive(:save).and_return(true)
          post action, :params => {:id => 'foo', :notifications_item => {:group_name => 'dude'}}
        end

        it_behaves_like 'it redirects the user and displays a success message'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          expect(Notifications::Item).to receive(:find).with('foo').and_return(dummy_item)
          post action, :params => {:id => 'foo', :notifications_item => {:group_name => 'dude'}}
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

  end

  describe 'destroy' do
    describe 'permissions' do
      let(:action) { :destroy }
      let(:dummy_item) { Notifications::Item.new }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          expect(Notifications::Item).to receive(:find).with('foo').and_return(dummy_item)
          expect(dummy_item).to receive(:destroy).and_return(true)
          post action, :params => {:id => 'foo', :notifications_item => {:group_name => 'dude'}}
        end

        it_behaves_like 'it redirects the user and displays a success message'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          expect(Notifications::Item).to receive(:find).with('foo').and_return(dummy_item)
          post action, :params => {:id => 'foo', :notifications_item => {:group_name => 'dude'}}
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

  end

  describe 'markdown' do
    describe 'permissions' do
      let(:action) { :markdown }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          expect(Notifications::Item).to receive(:markdown).and_return('lul')
          post action, :params => {:id => 'foo', :notifications_item => {:group_name => 'dude'}}
        end

        it_behaves_like 'it returns a success response'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          post action, :params => {:id => 'foo', :notifications_item => {:group_name => 'dude'}}
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

  end
end
